IF EXISTS (SELECT * FROM SYS.triggers WHERE NAME = 'TRG_EST_SNGPC_ENTRADA_ESTOQUE_DELETE') 
BEGIN
	DROP TRIGGER TRG_EST_SNGPC_ENTRADA_ESTOQUE_DELETE
END

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER dbo.TRG_EST_SNGPC_ENTRADA_ESTOQUE_DELETE ON dbo.EST_SNGPC_ENTRADA
WITH EXECUTE AS CALLER
FOR DELETE
AS
BEGIN

	-- DECLARAO DAS VARIVEIS
	DECLARE @CD_ENT     INT;
	DECLARE @CD_MOV     INT;
	DECLARE @CD_EMP     INT;
	DECLARE @CD_FILIAL  INT;
	DECLARE @CD_PROD    INT;
	DECLARE @CD_LOTE    INT;
    DECLARE @DT_MOV     DATETIME;
	DECLARE @QT_LOTE    INT;
    DECLARE @CD_USU     INT;
    DECLARE @SALDOLOTE  INT;
    DECLARE @SAIDASLOTE  INT;
	-- DEFINIO DAS VARIVEIS
	SELECT
		 @CD_ENT      = D.CD_ENT_SNGPC
		, @CD_EMP     = D.CD_EMP
        , @CD_USU     = D.CD_USU
		, @CD_FILIAL  = D.CD_FILIAL
		, @CD_PROD    = D.CD_PROD
		, @DT_MOV     = D.DT_MOV
		, @QT_LOTE    = D.QT_LOTE
        , @CD_LOTE    = D.CD_LOTE 
	FROM
		DELETED D;
	-- SELECIONA A MOVIMENTAO GERAL CORRESPONDENTE  ENTRADA
	SELECT
		@CD_MOV = CD_MOV
	FROM
		EST_SNGPC_ENT_SAI (NOLOCK)
	WHERE
		CD_ENT_SNGPC = @CD_ENT
	/******************************************************************/
	/* PROCESSO PARA EXCLUSO DO REGISTRO NA TABELA EST_SNGPC_ENT_SAI */
	/******************************************************************/
	-- EXCLUI O REGISTRO
	DELETE FROM EST_SNGPC_ENT_SAI WHERE CD_MOV = @CD_MOV;
	/**********************************************/
	/* PROCESSO PARA ATUALIZAO DO ESTOQUE FINAL */
	/* DOS REGISTROS NA TABELA EST_SNGPC_ENT_SAI  */
	/**********************************************/
	-- ATUALIZA ESTOQUE FINAL DE TODAS AS MOVIMENTAES POSTERIORES
	UPDATE
		EST_SNGPC_ENT_SAI
	SET
		QT_FINAL = QT_FINAL - @QT_LOTE
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD   = @CD_PROD
		AND (DT_MOV > @DT_MOV OR (DT_MOV = @DT_MOV AND CD_MOV > @CD_MOV));
  SET @SALDOLOTE  =
    (
      SELECT
        A.QT_LOTE
      FROM 
        EST_PROD_EST_SNGPC_LOTE_CPL (NOLOCK)  A
        INNER JOIN  EST_PROD_EST_SNGPC_LOTE (NOLOCK) B ON
          B.CD_LOTE   =A.CD_LOTE  
          AND B.CD_PROD    =@CD_PROD      
      WHERE     
          A. CD_LOTE   =@CD_LOTE
        AND A.CD_FILIAL   =@CD_FILIAL
        AND B.CD_PROD   =@CD_PROD       
    );   
 IF ( (@SALDOLOTE  -@QT_LOTE) < 0 ) 
 BEGIN
    RAISERROR('MOVIMENTAO NAO PODE SER EXCLUIDA QUANTIDADE INSUFICIENTE', 16, 1);
 END;  
 SET @SAIDASLOTE  =
 (SELECT               
   COUNT(A.CD_LOTE)       
 FROM                 
     EST_SNGPC_SAIDA (NOLOCK) A     
 INNER JOIN  EST_SNGPC_ENT_SAI (NOLOCK) S ON
    S.CD_SAI_SNGPC   = A.CD_SAI_SNGPC  
    AND S.CD_FILIAL  = A.CD_FILIAL    
 WHERE 
    A.CD_LOTE        =  @CD_LOTE
    AND A.DT_MOV     >= @DT_MOV
    AND A.CD_FILIAL  = @CD_FILIAL
    AND S.CD_PROD    = @CD_PROD
 )
 IF ( @SAIDASLOTE > 0 ) 
 BEGIN
    RAISERROR('MOVIMENTAO NAO PODE SER EXCLUIDA JA FORAM FEITAS VENDAS DO LOTE ', 16, 1);
 END; 
   
END